/*
 * Decompiled with CFR 0.152.
 */
package fabric.me.thosea.badoptimizations.utils.fabric;

import fabric.me.thosea.badoptimizations.config.Config;
import fabric.me.thosea.badoptimizations.hook.CacheHooks;
import fabric.me.thosea.badoptimizations.hook.HookCreator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;

public final class PlatformMethodsImpl {
    private PlatformMethodsImpl() {
    }

    public static String getVersion() {
        return PlatformMethodsImpl.ownModContainer().getMetadata().getVersion().getFriendlyString();
    }

    public static Path getConfigFolder() {
        return FabricLoader.getInstance().getConfigDir();
    }

    public static boolean isModLoaded(String id) {
        return FabricLoader.getInstance().isModLoaded(id);
    }

    public static boolean isOnServer() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER;
    }

    public static InputStream streamConfigTemplate() throws IOException {
        return Files.newInputStream((Path)PlatformMethodsImpl.ownModContainer().findPath("bo-config-template.txt").orElseThrow(() -> new RuntimeException("BadOptimizations config template not found")), new OpenOption[0]);
    }

    private static ModContainer ownModContainer() {
        return (ModContainer)FabricLoader.getInstance().getModContainer("badoptimizations").orElseThrow(() -> new RuntimeException("BadOptimizations mod container not found"));
    }

    public static Map<String, List<String>> getModIncompatibilities() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(1);
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            ModMetadata meta = mod.getMetadata();
            String id = meta.getId();
            CustomValue object = meta.getCustomValue("badoptimizations:incompatibilities");
            if (object == null) continue;
            if (object.getType() != CustomValue.CvType.ARRAY) {
                Config.LOGGER.warn("Mod {} specifies invalid BadOptimizations incompatibilities, ignoring", (Object)id);
                Config.LOGGER.warn("JSON is not an array");
                continue;
            }
            ArrayList<String> entries = new ArrayList<String>();
            for (CustomValue entry : object.getAsArray()) {
                if (entry == null || entry.getType() != CustomValue.CvType.STRING) {
                    Config.LOGGER.warn("Mod {} specifies invalid BadOptimizations incompatibilities", (Object)id);
                    Config.LOGGER.warn("JSON array contained non-string component");
                    continue;
                }
                entries.add(entry.getAsString());
            }
            result.put(id, entries);
        }
        return result;
    }

    public static List<CacheHooks.CacheHookEntry> getModCacheHooks() {
        ArrayList<CacheHooks.CacheHookEntry> result = new ArrayList<CacheHooks.CacheHookEntry>();
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            ModMetadata meta = mod.getMetadata();
            String modId = meta.getId();
            CustomValue value = meta.getCustomValue("badoptimizations:cache_hooks");
            if (value == null) continue;
            if (value.getType() != CustomValue.CvType.OBJECT) {
                Config.LOGGER.warn("Mod {} specifies invalid BadOptimizations caching hooks, ignoring", (Object)modId);
                Config.LOGGER.warn("JSON is not an object");
                continue;
            }
            CustomValue.CvObject object = value.getAsObject();
            BooleanSupplier common = PlatformMethodsImpl.getEntry(modId, object, "common");
            BooleanSupplier lightmap = PlatformMethodsImpl.getEntry(modId, object, "lightmap");
            BooleanSupplier skyColor = PlatformMethodsImpl.getEntry(modId, object, "skycolor");
            if (common == null && lightmap == null && skyColor == null) continue;
            CacheHooks.CacheHookEntry entry = new CacheHooks.CacheHookEntry(common, lightmap, skyColor);
            result.add(entry);
        }
        return result;
    }

    private static BooleanSupplier getEntry(String modId, CustomValue.CvObject object, String key) {
        CustomValue value = object.get(key);
        if (value == null) {
            return null;
        }
        if (value.getType() != CustomValue.CvType.STRING) {
            Config.LOGGER.warn("Mod {} specifies an invalid BadOptimizations caching hook", (Object)modId);
            Config.LOGGER.warn("JSON key {} is not a string", (Object)key);
            return null;
        }
        String clazz = value.getAsString();
        BooleanSupplier hook = HookCreator.tryCreateHook(modId, clazz);
        if (hook != null) {
            Config.LOGGER.info("Mod {} added a {} caching hook: {}", new Object[]{modId, key, clazz});
        }
        return hook;
    }
}

